#pragma once

#include <yandex_io/sdk/sdk_interface.h>
#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>

namespace YandexIO {

    class XivaPushAliceRequester: public YandexIO::PushNotificationObserver {
    public:
        // create and setup XivaPushAliceRequester
        static std::shared_ptr<XivaPushAliceRequester> install(YandexIO::SDKInterface& sdk);

        // PushNotificationObserver api
        void onPushNotification(const std::string& operation, const std::string& message) override;

    private:
        explicit XivaPushAliceRequester(std::shared_ptr<IAliceCapability> aliceCapability);
        const std::shared_ptr<IAliceCapability> aliceCapability_;
    };

} // namespace YandexIO
