import sys


def iter_symbols(lines):
    for line in lines:
        cols = line.strip().split()
        assert len(cols) == 2
        assert cols[0] == 'C'
        yield cols[1]


def iter_exports_source(symbols):
    yield '// A hack to pull all public symbols as "needed" '
    yield '// so their respective staticlibs are not discarded early'
    yield ''

    for sym in symbols:
        yield 'extern void {sym}();'.format(sym=sym)
    yield ''

    yield 'const void* const QUASAR_GSTREAMER_EXPORTS[] = {'
    for sym in symbols:
        yield '    {sym},'.format(sym=sym)
    yield '};'


def main():
    with open(sys.argv[1], 'r') as f:
        symbols = sorted(iter_symbols(f))

    for line in iter_exports_source(symbols):
        sys.stdout.write(line)
        sys.stdout.write('\n')


if __name__ == "__main__":
    main()
