OWNER(g:yandex_io)

LIBRARY()

# NOTE: see comment on LICENSE in parent directory
LICENSE(LGPL-2.0-only)

NO_RUNTIME()

# glib
PEERDIR(
    contrib/restricted/glib/glib
    contrib/restricted/glib-networking/tls/openssl
)

# gstreamer core libs
PEERDIR(
    contrib/restricted/gstreamer/gst
    contrib/restricted/gstreamer/libs/gst/net
    contrib/restricted/gst-plugins-base/gst-libs/gst/app
)

# gstreamer core plugins (coreelements)
PEERDIR(
    contrib/restricted/gstreamer/plugins/elements
)

# gst-plugins-base
PEERDIR(
    contrib/restricted/gst-plugins-base/ext/ogg
    contrib/restricted/gst-plugins-base/ext/opus
    contrib/restricted/gst-plugins-base/gst/app
    contrib/restricted/gst-plugins-base/gst/audioconvert
    contrib/restricted/gst-plugins-base/gst/audiomixer
    contrib/restricted/gst-plugins-base/gst/audiorate
    contrib/restricted/gst-plugins-base/gst/audioresample
    contrib/restricted/gst-plugins-base/gst/gio
    contrib/restricted/gst-plugins-base/gst/pbtypes
    contrib/restricted/gst-plugins-base/gst/playback
    contrib/restricted/gst-plugins-base/gst/typefind
    contrib/restricted/gst-plugins-base/gst/volume
)

# gst-plugins-good
PEERDIR(
    contrib/restricted/gst-plugins-good/ext/soup
    contrib/restricted/gst-plugins-good/gst/audiofx
    contrib/restricted/gst-plugins-good/gst/autodetect
    contrib/restricted/gst-plugins-good/gst/audioparsers
    contrib/restricted/gst-plugins-good/gst/equalizer
    contrib/restricted/gst-plugins-good/gst/id3demux
    contrib/restricted/gst-plugins-good/gst/isomp4
    contrib/restricted/gst-plugins-good/gst/spectrum
    contrib/restricted/gst-plugins-good/gst/wavparse
)

# gst-plugins-bad
PEERDIR(
    contrib/restricted/gst-plugins-bad/ext/dash
    contrib/restricted/gst-plugins-bad/ext/hls
    contrib/restricted/gst-plugins-bad/gst/mpegtsdemux
)

IF (OS_ANDROID)
    CFLAGS(GLOBAL -DQUASAR_GSTREAMER_OPENSLES)
    PEERDIR(
        contrib/restricted/gst-plugins-bad/sys/opensles
    )
ENDIF()

IF (OS_LINUX)
    CFLAGS(GLOBAL -DQUASAR_GSTREAMER_ALSA)
    PEERDIR(
        contrib/restricted/gst-plugins-base/ext/alsa
    )
ENDIF()

DEFAULT(USE_GSTREAMER_LIBAV yes)
IF (USE_GSTREAMER_LIBAV)
    # use gst-libav for decoding mp3 and aac
    CFLAGS(GLOBAL -DQUASAR_GSTREAMER_LIBAV)
    PEERDIR(
        contrib/restricted/patched/gst-libav/ext/libav
    )
ELSE()
    # use mpg123 for decoding mp3
    # use fdkaac for decoding aac
    PEERDIR(
        contrib/restricted/gst-plugins-good/ext/mpg123
        contrib/restricted/gst-plugins-bad/ext/fdkaac
    )
ENDIF()

END()
