OWNER(g:yandex_io)

LIBRARY()

LICENSE(LGPL-2.0-only)
# NOTE: This 'license' stuff is important.
#
# All production builds must be LGPL-compliant:
# 1. An application MUST link against Gstreamer-based audio player dynamically.
# 2. Gstreamer-based audio player (this library) MUST only use libraries
#    eligible for source distribution under LGPL.
#
# Non-compliant fully static builds MAY be used internally without distribution.

IF (USE_DYNAMIC_QUASAR_GSTREAMER)
    # All distributed builds must be compliant
    PEERDIR(yandex_io/oss_libs/gstreamer/dynamic)

    # TODO: remove usage of gstreamer from public headers
    ADDINCL(
        GLOBAL contrib/restricted/glib/include
        GLOBAL contrib/restricted/glib/include/glib
        GLOBAL contrib/restricted/glib/include/gmodule
        GLOBAL contrib/restricted/gstreamer/gst/include
        GLOBAL contrib/restricted/gstreamer/libs/gst/base/include
        GLOBAL contrib/restricted/gstreamer/libs/gst/net/include
        GLOBAL contrib/restricted/gst-plugins-base/gst-libs/gst/app/include
        GLOBAL contrib/restricted/gst-plugins-base/gst-libs/gst/audio/include
    )

    # FIXME: these are transitive dependencies of gstreamer plugins
    # they must be propagated to the final program manually
    # due to implementation details of DEV_DLL_PROXY
    IF (OS_ANDROID)
        PEERDIR(
            contrib/libs/libiconv
            yandex_io/libs/android_support/opensles
        )
    ENDIF()
ELSE()
    # Non-compliant builds may be used for debugging/testing
    PEERDIR(yandex_io/oss_libs/gstreamer/static)
ENDIF()

END()

RECURSE(
    dynamic
    dynamic_lib
    static
)
