#include "enum_names.h"

#include <array>
#include <string_view>

using namespace quasar::proto;

std::string quasar::wifiConnectResponseStatusName(WifiConnectResponse_Status value) {
    static_assert(WifiConnectResponse_Status_Status_MAX == WifiConnectResponse_Status_TIMEOUT);
    static constexpr std::string_view values[WifiConnectResponse_Status_Status_MAX + 1] = {
        "OK",
        "SSID_NOT_FOUND",
        "AUTH_ERROR",
        "TIMEOUT",
    };
    return std::string(values[int(value)]);
}

std::string quasar::addUserResponseStatusName(AddUserResponse_Status value) {
    static_assert(AddUserResponse_Status_Status_MAX == AddUserResponse_Status_INVALID_TOKEN);

    switch (value)
    {
        case AddUserResponse::OK:
            return "OK";
        case AddUserResponse::NO_INTERNET:
            return "NO_INTERNET";
        case AddUserResponse::CODE_EXPIRED:
            return "CODE_EXPIRED";
        case AddUserResponse::CRYPTO_ERROR:
            return "CRYPTO_ERROR";
        case AddUserResponse::INVALID_TOKEN:
            return "INVALID_TOKEN";
        default:
            throw std::runtime_error("Unknown addUserResponseStatus: " + std::to_string(int(value)));
    }
}

std::string quasar::wifiTypeName(WifiType value) {
    static_assert(WifiType_MAX == WifiType::NONE_WIFI_TYPE);

    static constexpr std::string_view values[WifiType_MAX + 1] = {
        "WEP",
        "WPA",
        "OPEN",
        "UNKNOWN",
        "NONE",
    };
    return std::string(values[int(value)]);
}

void quasar::wifiTypeParse(const std::string& wifiType, WifiType* value) {
    static_assert(WifiType_MAX == WifiType::NONE_WIFI_TYPE);

    if ("WPA" == wifiType) {
        *value = WifiType::WPA;
    } else if ("WEP" == wifiType) {
        *value = WifiType::WEP;
    } else if ("OPEN" == wifiType) {
        *value = WifiType::OPEN;
    } else if ("UNKNOWN" == wifiType) {
        *value = WifiType::UNKNOWN_WIFI_TYPE;
    } else if ("NONE" == wifiType) {
        *value = WifiType::NONE_WIFI_TYPE;
    } else {
        throw std::runtime_error("Cannot parse wifi type: '" + wifiType + "'");
    }
}

std::string quasar::networkStatusStatusName(NetworkStatus_Status value) {
    static_assert(NetworkStatus_Status_Status_MAX == NetworkStatus_Status_NOT_CHOSEN);
    static constexpr std::string_view values[NetworkStatus_Status_Status_MAX + 1] = {
        "NOT_CONNECTED",
        "CONNECTING",
        "CONNECTED_NO_INTERNET",
        "CONNECTED",
        "NOT_CHOSEN",
    };

    return std::string(values[int(value)]);
}

std::string quasar::wifiStatusStatusName(WifiStatus_Status value) {
    static_assert(WifiStatus_Status_Status_MAX == WifiStatus_Status_NOT_CHOSEN);

    static constexpr std::string_view values[WifiStatus_Status_Status_MAX + 1] = {
        "NOT_CONNECTED",
        "CONNECTING",
        "CONNECTED_NO_INTERNET",
        "CONNECTED",
        "NOT_CHOSEN",
    };

    return std::string(values[int(value)]);
}

std::string quasar::wifiStatusSpeedName(WifiStatus_Speed value) {
    static_assert(WifiStatus_Speed_Speed_MAX == WifiStatus_Speed_FAST);

    static constexpr std::string_view values[WifiStatus_Speed_Speed_MAX + 1] = {
        "UNKNOWN",
        "LOW",
        "MIDDLE",
        "FAST",
    };

    return std::string(values[int(value)]);
}
