import json
import os

AUDIO_DEVICE_PORT = 10000
TESTPOINT_PORT = 9999


def groom_config(config_path, deviceid_path, device_id, local_ports_getter=lambda port: port):
    with open(config_path, 'r') as f:
        config = json.load(f)

    ports = []

    for _, service_config in config.items():
        if 'port' in service_config:
            port = service_config['port']
            service_config['bind'] = '0.0.0.0'
            local_port = local_ports_getter(port)
            ports.append((local_port, port))
            service_config['local_port'] = local_port
        if 'Logging' in service_config and 'file' in service_config["Logging"]:
            service_config['Logging']['file']['maxFileSize'] = "10MB"

    local_audio_device_port = local_ports_getter(AUDIO_DEVICE_PORT)
    config['audiod']['audioDevice'] = {
        'device': 'tcp',
        'bind': '0.0.0.0',
        'port': AUDIO_DEVICE_PORT,
        'local_port': local_audio_device_port,
    }

    ports.append((local_audio_device_port, AUDIO_DEVICE_PORT))

    local_testpoint_port = local_ports_getter(TESTPOINT_PORT)
    config['testpoint'] = {}
    config['testpoint']["use_testpoint_preprocessor"] = True
    config['testpoint']['bind'] = '0.0.0.0'
    config['testpoint']['port'] = TESTPOINT_PORT
    config['testpoint']['local_port'] = local_testpoint_port
    config["common"]["backendUrl"] = "https://quasar.yandex.ru"

    ports.append((local_testpoint_port, TESTPOINT_PORT))

    beacon_port = config.get('glagold', {}).get('beaconPort')
    if beacon_port is not None:
        ports.append((local_ports_getter(beacon_port), beacon_port))
    external_port = config.get('glagold', {}).get('externalPort')
    if external_port is not None:
        ports.append((local_ports_getter(external_port), external_port))
    http_port = config.get('firstrund', {}).get('httpPort')
    if http_port is not None:
        ports.append((local_ports_getter(http_port), http_port))

    with open(config_path, 'w') as f:
        json.dump(config, f, sort_keys=True, indent=2)

    with open(deviceid_path, 'w') as f:
        f.write(device_id)

    return ports


def forward_ports(port_pairs, device):
    for local_port, remote_port in port_pairs:
        device.forward(local_port, remote_port)


def prepare_for_presmoke(device, path, port_getter=lambda port: port):
    config_path = os.path.join(path, 'quasar.cfg')
    deviceid_path = os.path.join(path, 'device_id')
    device.remount()
    device.pull("/system/vendor/quasar/quasar.cfg", config_path)
    port_pairs = groom_config(config_path, deviceid_path, device.device_id, port_getter)
    device.push(config_path, "/system/vendor/quasar/quasar.cfg")
    device.shell("/system/vendor/quasar/q restart")
    forward_ports(port_pairs, device)
    device.shell("touch /data/quasar_activate_adb_sound")
    device.shell("touch /data/quasar_activate_adb_quasmodrom")
    device.shell("touch /data/quasar_activate_adb_glagol")
    device.shell("touch /data/quasar_activate_network_adb")
