package ru.yandex.quasar.android_app.example_app

import android.Manifest
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.content.ServiceConnection
import android.content.pm.PackageManager
import android.util.Log
import android.os.Bundle
import android.os.IBinder
import android.widget.Button
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import ru.yandex.quasar.android_app.example_app.YandexIoServiceImpl
import ru.yandex.io.sdk.YandexIoService

class MainActivity : AppCompatActivity() {
    private val TAG = "Quasar"

    private var mService: YandexIoService? = null
    /** Flag indicating whether we have called bind on the service.  */
    private var mBound: Boolean = false

    private var mButton:Button? = null
    private var RECORD_AUDIO_CODE_REQUEST = 1;

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        mButton = findViewById(R.id.AliceButton)
        mButton!!.setOnClickListener {
            /* Toggle alice conversation */
            onAliceButtonClicked()
        }

        /* Check required permissions before starting YandexIoService */
        val res = ContextCompat.checkSelfPermission(
            applicationContext,
            Manifest.permission.RECORD_AUDIO
        )
        if (res == PackageManager.PERMISSION_GRANTED) {
            wakeUpAndBind()
        } else {
            ActivityCompat.requestPermissions(this, arrayOf(Manifest.permission.RECORD_AUDIO), RECORD_AUDIO_CODE_REQUEST);
        }
    }

     override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray) {
         super.onRequestPermissionsResult(requestCode, permissions, grantResults)
         when (requestCode) {
            RECORD_AUDIO_CODE_REQUEST -> if (grantResults.isNotEmpty()
                && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                Toast.makeText(this@MainActivity, "Permission Granted!", Toast.LENGTH_SHORT).show()
                // Got permissions for audio record. Can start YandexIoService now
                wakeUpAndBind()
            } else {
                Toast.makeText(this@MainActivity, "Permission Denied! Can't run Quasar without permissions. Close APK", Toast.LENGTH_LONG).show()
                finish();
            }
        }
    }

    /** Defines callbacks for service binding, passed to bindService()  */
    private val mConnection = object : ServiceConnection {

        override fun onServiceConnected(className: ComponentName, service: IBinder) {
            /* Save service */
            Log.w(TAG, "Service connecnted")
            val binder = service as YandexIoService.LocalBinder
            mService = binder.getService()
            mBound = true
        }

        override fun onServiceDisconnected(arg0: ComponentName) {
            Log.w(TAG, "Service disconnected")
            mService = null
            mBound = false
        }
    }

    override fun onDestroy() {
        stopService(Intent(applicationContext, YandexIoServiceImpl::class.java))
        super.onDestroy()
    }

    override fun onStop() {
        super.onStop()
        unbindService(mConnection)
        mBound = false
    }

    private fun wakeUpAndBind() {
        Log.w(TAG, "Trying to start Service at ru.yandex.quasar.android_app.example_app.MainActivity.wakeUpAndBind")
        YandexIoService.wakeUp(applicationContext, YandexIoServiceImpl::class.java)
        Log.w(TAG, "Service is started at ru.yandex.quasar.android_app.example_app.MainActivity.wakeUpAndBind")
        Log.w(TAG, "bindService")
        Intent(this, YandexIoServiceImpl::class.java).also { intent ->
            bindService(intent, mConnection, Context.BIND_AUTO_CREATE)
        }
    }

    private fun onAliceButtonClicked() {
        Log.w(TAG, "Button is clicked")
        if (mBound) {
            Log.w(TAG, "Start conversation")
            mService!!.toggleConversation()
        }
    }


}
