package ru.yandex.quasar.android_app.example_app

import android.content.Context
import android.content.Intent
import android.os.Build
import ru.yandex.io.sdk.AndroidDeviceInfo
import ru.yandex.io.sdk.IoSdkSettings
import ru.yandex.io.sdk.YandexIoService
import android.util.Log

class YandexIoServiceImpl : YandexIoService() {

    override fun createDeviceInfo() = object : AndroidDeviceInfo(this@YandexIoServiceImpl) {
        override val quasarDeviceId = "nor_device_id"
        override val quasarPlatform = "development"
        override val appId = "aliced"
    }

    override fun createIoSdkSettings() = IoSdkSettings.DEFAULT

    override fun onCreate() {
        Log.d(TAG, "trying to create Yandex IO Service IMPL")
        super.onCreate()
        Log.d(TAG, "Yandex IO Service IMPL created")
    }

    override fun onDestroy() {
        Log.d(TAG, "Yandex IO Service IMPL destroyed")
        super.onDestroy()
    }

    override fun onQuasarStart() {
        Log.d(TAG, "starting sample_app related quasar stuff")
    }

    override fun onQuasarStarted() {
        Log.d(TAG, "pos start sample_app quasar stuff")
        super.startAudioRecording()
    }

    companion object {
        private const val TAG = "Quasar"
    }
}
