#pragma once

#include <yandex_io/libs/hal/hal.h>

class SampleHAL: public YandexIO::HAL {
    std::optional<YandexIO::HALInfo> getHALInfo() override;

    std::shared_ptr<BluetoothLE> createBluetoothLE() override;

    std::unique_ptr<YandexIO::DeviceCryptography> createDeviceCryptography(const Json::Value& config) override;

    quasar::BluetoothCapabilities& getBluetoothCapabilities() override;

    std::shared_ptr<YandexIO::IIotDiscoveryProvider> createIotDiscoveryProvider() override;
};
