#include "sample_volume_manager.h"

SampleVolumeManager::SampleVolumeManager(std::shared_ptr<YandexIO::IDevice> device,
                                         std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
                                         std::shared_ptr<YandexIO::SDKInterface> sdk,
                                         const std::string& currentVolumeFilename,
                                         const std::string& currentMuteStateFilename)
    : VolumeManager(std::move(device), std::move(ipcFactory), std::move(sdk), currentVolumeFilename, currentMuteStateFilename)
{
}

void SampleVolumeManager::setVolumeImplementation(int /* platformVolume */) {
    // do nothing
}

int SampleVolumeManager::minVolume() {
    return 0;
}

int SampleVolumeManager::maxVolume() {
    return 10;
}

int SampleVolumeManager::volumeStep() {
    return 1;
}

int SampleVolumeManager::scaleFromAlice(int aliceVolume) {
    return aliceVolume;
}

int SampleVolumeManager::scaleToAlice(int platformVolume) {
    return platformVolume;
}

int SampleVolumeManager::initialVolume() {
    return 5;
}
