#pragma once

#include <yandex_io/modules/volume_manager/base/volume_manager.h>
#include <yandex_io/sdk/sdk_interface.h>

class SampleVolumeManager: public VolumeManager {
public:
    SampleVolumeManager(std::shared_ptr<YandexIO::IDevice> device,
                        std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
                        std::shared_ptr<YandexIO::SDKInterface> sdk,
                        const std::string& currentVolumeFilename,
                        const std::string& currentMuteStateFilename);

protected:
    void setVolumeImplementation(int platformVolume) override;

    int minVolume() override;
    int maxVolume() override;
    int volumeStep() override;

    int scaleFromAlice(int aliceVolume) override;

    int scaleToAlice(int platformVolume) override;

    int initialVolume() override;
};
