#pragma once

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <list>
#include <memory>
#include <string>
#include <thread>

namespace quasar {

    class YandexIOEndpoint {
    public:
        YandexIOEndpoint(std::shared_ptr<YandexIO::IDevice> device, std::string endpointName);

        void addService(std::unique_ptr<QuasarService> service);

        template <typename T, typename... Args>
        void addService(Args&&... args) {
            addService(std::make_unique<T>(std::forward<Args>(args)...));
        }

        void addStubService(const std::shared_ptr<ipc::IIpcFactory>& ipcFactory, const std::string& name);

        void startAll();

        /**
         * @brief call Sync for all QuasarServices
         * @note Should be used in tests to synchronize internal IPCs state
         */
        void sync();

    private:
        std::shared_ptr<YandexIO::IDevice> device_;
        std::string endpointName_;
        std::list<std::unique_ptr<QuasarService>> services_;
    };
} // namespace quasar
