#pragma once

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/mixed/mixed_ipc_factory.h>

#include <functional>
#include <map>
#include <mutex>

class QuasarCallParams {
public:
    struct Args {
        int argc = 0;
        char** argv = nullptr;

        YandexIO::DeviceID deviceId;
        std::unique_ptr<YandexIO::HAL> hal;
        std::optional<std::string> color;
        std::optional<std::string> revision;
    };

public:
    QuasarCallParams(Args args);
    ~QuasarCallParams();

    QuasarCallParams(const QuasarCallParams&) = delete;
    QuasarCallParams& operator=(const QuasarCallParams&) = delete;

    int argc() const {
        return args_.argc;
    }

    char** argv() const {
        return args_.argv;
    }

    // Get argument at `index`
    const char* arg(int index) const;

    // Constructed lazily
    std::shared_ptr<YandexIO::Configuration> configuration();
    std::shared_ptr<YandexIO::IDevice> device();
    std::shared_ptr<quasar::ipc::MixedIpcFactory> mixedIpcFactory();

private:
    // this class should not be used away from entry point in the main thread,
    // however this mutex protects in case someone manages to do it anyway
    mutable std::recursive_mutex mutex_;

    Args args_;

    std::shared_ptr<YandexIO::Configuration> configuration_;
    std::shared_ptr<YandexIO::IDevice> device_;
    std::shared_ptr<quasar::ipc::MixedIpcFactory> mixedIpcFactory_;
};

using QuasarMain = std::function<int(QuasarCallParams& params)>;

using QuasarCallScheme = std::map<std::string, QuasarMain>;
using DaemonsCallScheme = QuasarCallScheme;

int callDaemons(QuasarCallParams& params, const DaemonsCallScheme& daemons);
