#include "fluent_bitd.h"

#include <yandex_io/scaffolding/base/utils.h>

#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/logging_handler/logging_handler.h>
#include <yandex_io/libs/minidump/quasar_minidump.h>
#include <yandex_io/libs/telemetry_handler/telemetry_handler.h>
#include <yandex_io/libs/terminate_waiter/terminate_waiter.h>
#include <yandex_io/services/fluent-bitd/fluent_bit_client.h>
#include <yandex_io/services/fluent-bitd/fluent_bit_service.h>

using namespace quasar;

int fluent_bitd(QuasarCallParams& params)
{
    TerminateWaiter waiter;

    const auto device = params.device();
    const auto ipcFactory = params.mixedIpcFactory();

    ipcFactory->setProcessName("fluent-bitd");

    sendDaemonStartMetric("fluent-bitd", device);
    LoggingHandler loggingHandler;
    loggingHandler.init(ipcFactory, FluentBitService::SERVICE_NAME, device->configuration()->getFullConfig(), device->telemetry());

    TelemetryHandler telemetryHandler;
    telemetryHandler.init(device->telemetry(), ipcFactory);

    YIO_LOG_INFO("Starting service fluent-bitd version " << device->softwareVersion());

    const auto& config = device->configuration()->getServiceConfig(FluentBitService::SERVICE_NAME);
    QuasarMinidump::getInstance().init(FluentBitService::SERVICE_NAME, config, device->telemetry(), device->softwareVersion());

    FluentBitService fluentBitService(device, ipcFactory, std::make_unique<FluentBitClient>(device, config));
    fluentBitService.start();

    waiter.wait();
    fluentBitService.stop();

    return 0;
}

void addFluentbitServices(quasar::YandexIOEndpoint& endpoint, QuasarCallParams& params) {
    const auto device = params.device();
    const auto ipcFactory = params.mixedIpcFactory();
    const auto& config = device->configuration()->getServiceConfig(FluentBitService::SERVICE_NAME);
    endpoint.addService<FluentBitService>(device, ipcFactory, std::make_unique<FluentBitClient>(device, config));
}
