#pragma once

#include <yandex_io/libs/device/device.h>
#include <yandex_io/libs/glagol_sdk/discovery.h>
#include <yandex_io/libs/threading/periodic_executor.h>
#include <yandex_io/services/glagold/responder_status.h>

namespace quasar {

    class GlagolAvahiServerWatchdog {
    public:
        GlagolAvahiServerWatchdog(std::shared_ptr<YandexIO::IDevice> device, bool shouldAbortIfServerLost, std::shared_ptr<ResponderStatus> responderStatus);

    private:
        void onDiscoveryResultChanged(const glagol::Discovery::Result& result);
        void checkServerVisibility();

        std::shared_ptr<YandexIO::IDevice> device_;
        std::shared_ptr<ResponderStatus> responderStatus_;
        glagol::DeviceId deviceId_;
        std::shared_ptr<glagol::Discovery> discovery_;
        std::unique_ptr<PeriodicExecutor> periodicExecutor_;
        std::mutex mutex_;
        bool visible_ = false;
        std::chrono::steady_clock::time_point lastVisibilityChange_;
        std::chrono::milliseconds maxServerNonVisiblePeriod_;
        bool shouldAbortIfServerLost_;
    };

} // namespace quasar
