#pragma once

#include <yandex_io/scaffolding/base/endpoint.h>
#include <yandex_io/scaffolding/base/entry.h>

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/metrics_collector/i_metrics_collector.h>
#include <yandex_io/metrica/monitor/metrics_collector/ping_manager/ping_manager.h>

#include <functional>
#include <memory>

int telemetry(QuasarCallParams& params, std::unique_ptr<quasar::IMetricsCollector> collector);

template <class CollectorT>
int telemetry(QuasarCallParams& params)
{
    const auto device = params.device();
    const auto ipcFactory = params.mixedIpcFactory();
    const auto pingManager = std::make_shared<quasar::PingManager>();
    const auto periodSec = quasar::tryGetInt(device->configuration()->getServiceConfig("monitord"), "metricsCollectorPeriodSec", 10);

    ipcFactory->setProcessName("telemetry");
    auto collector = std::make_unique<CollectorT>(device, ipcFactory, pingManager, std::chrono::seconds{periodSec});
    return telemetry(params, std::move(collector));
}

void addTelemetryServices(quasar::YandexIOEndpoint& endpoint, QuasarCallParams& params, std::unique_ptr<quasar::IMetricsCollector> collector);

template <class CollectorT>
void addTelemetryServices(quasar::YandexIOEndpoint& endpoint, QuasarCallParams& params) {
    const auto device = params.device();
    const auto ipcFactory = params.mixedIpcFactory();
    const auto periodSec = quasar::tryGetInt(device->configuration()->getServiceConfig("monitord"), "metricsCollectorPeriodSec", 10);
    auto collector = std::make_unique<CollectorT>(device, ipcFactory, std::chrono::seconds{periodSec});
    return addTelemetryServices(endpoint, params, std::move(collector));
}
