#include "updatesd.h"

#include <yandex_io/scaffolding/base/utils.h>

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/device/defines.h>
#include <yandex_io/libs/http_client/http_client.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/libs/logging/setup/setup.h>
#include <yandex_io/libs/minidump/quasar_minidump.h>
#include <yandex_io/libs/terminate_waiter/terminate_waiter.h>
#include <yandex_io/services/updatesd/updater.h>

using namespace quasar;

int updatesd(QuasarCallParams& params)
{
    TerminateWaiter waiter;

    const auto device = params.device();
    const auto ipcFactory = params.mixedIpcFactory();

    ipcFactory->setProcessName("updatesd");
    {
        const auto& config = device->configuration()->getServiceConfig(Updater::SERVICE_NAME);
        Logging::initLogging(config);
        Logging::addLoggingToTelemetryIfNeeded(config, device->telemetry());
        YIO_LOG_INFO("Starting service updatesd version " << device->softwareVersion());
        QuasarMinidump::getInstance().init(Updater::SERVICE_NAME, config, device->telemetry(), device->softwareVersion());
    }

    sendDaemonStartMetric("updatesd", device);
    constexpr auto otaConfirmSoftTimeout = std::chrono::minutes(5);
    constexpr auto otaConfirmHardTimeout = std::chrono::minutes(30);
    Updater updater(device, ipcFactory, otaConfirmSoftTimeout, otaConfirmHardTimeout);
    updater.start();

    waiter.wait();

    return 0;
}
