#pragma once

//
// © YANDEX LLC, 2018
//

#pragma once

#include <string>

namespace YandexIO {
    class AlarmObserver {
    public:
        enum class AlarmType {
            CLASSIC_ALARM,
            MEDIA_ALARM,
            TIMER
        };

        /**
         * @brief Synchronization mechanism. See YandexIOSDK::approveAlarm() for more details
         * @note  From this event alarm should be considered playing
         * @param alarmType - either CLASSIC_ALARM or TIMER. For this case CLASSIC_ALARM == MEDIA_ALARM == ALARM,
         *                    just indicates that raising volume should be started
         * @param alarmId - alarm id that needs to be approved
         */
        virtual void onAlarmEnqueued(AlarmType alarmType, const std::string& alarmId) = 0;

        virtual void onAlarmStarted(AlarmType alarmType) = 0;
        virtual void onAlarmStopped(AlarmType alarmType, bool hasRemainingMedia) = 0;

        virtual void onAlarmStopRemainingMedia() = 0;

        /**
         * @brief general settings for all alarms
         */
        struct AlarmsSettings {
            int startVolume;
            int finishVolume;
            int volumeRaiseStepMs;
        };
        virtual void onAlarmsSettingsChanged(const AlarmsSettings& alarmsSettings) = 0;

        virtual ~AlarmObserver() = default;
    };

} // namespace YandexIO
