#pragma once

#include <string>

namespace YandexIO {
    /**
     * Class can be used to set volume by voice. When user asks Alice to handle volume, it returns directives.
     * They must be handled on vendor side, because we don't know anything about device volume scale.
     */
    class AliceVolumeSetter {
    public:
        static constexpr const char* SOURCE_VOICE = "voice";
        static constexpr const char* SOURCE_OTHER = "other";

        virtual void volumeUp(const std::string& source = SOURCE_VOICE) = 0;
        virtual void volumeDown(const std::string& source = SOURCE_VOICE) = 0;
        /**
         * Method is called when set volume directive comes
         * @param aliceVolume -- volume from 0 to 10
         */
        virtual void setVolume(int aliceVolume, bool animate = true, const std::string& source = SOURCE_VOICE) = 0;
        virtual void mute() = 0;
        virtual void unmute() = 0;

        virtual ~AliceVolumeSetter() = default;
    };

} // namespace YandexIO
