#pragma once

#include <string>

namespace YandexIO {
    struct AudioMetadata {
        std::string title;
        std::string subtitle;
        std::string artImageUrl;
        bool hideProgressBar;
    };

    struct Audio {
        enum Screen {
            DEFAULT,
            MUSIC,
            RADIO
        };

        int positionSec;
        int durationSec;
        std::string providerName;
        Screen screenType;
        AudioMetadata metadata;
    };

    enum class AudioClientState {
        IDLE,
        BUFFERING,
        PLAYING,
        PAUSED,
        STOPPED,
        FINISHED,
        FAILED
    };

    struct AudioPlayerDescriptor {
        enum class PlayerType {
            AUDIO,
            VOICE,
            STREAM,
            FILE_PLAYER
        };

        PlayerType type;
    };

    struct AudioClientEvent {
        enum class Event {
            STATE_CHANGED,
            HEARTBEAT,
            NEARLY_FINISHED
        };

        Event event;
        AudioClientState state;
        Audio audio;
        AudioPlayerDescriptor playerDescriptor;
    };

} // namespace YandexIO
