#pragma once

//
// © YANDEX LLC, 2019
//

#pragma once

#include <string>

namespace YandexIO {
    class AuthObserver {
    public:
        /**
         * @brief Callback will be called on authentication try. Can be used in pair with authenticate() method in YandexIOSDK to see,
         * was authentication successful or not asynchronously.
         * @param oauthCode -- oauthCode used to authenticate
         * @param isOk -- was it successful
         * @param message -- response message. It's in JSON format, it has two fields:
         * 1. addUserStatus -- string. It represents result of getting token from oauthCode. Has 3 options: OK, CODE_EXPIRED, NO_INTERNET.
         * 2. registerResponse -- JSON. Response of register request. If addUserStatus is not OK, this field make no sense.
         */
        virtual void onAuthenticationStatus(const std::string& oauthCode, bool isOk, const std::string& message) = 0;

        /**
         * @brief Callback will be called when some of YandexIOSDK components will receive token expired error.
         */
        virtual void onInvalidOAuthToken(const std::string& oauthToken) = 0;

        /**
         * @brief Callback will be called when some of YandexIOSDK components will receive auth error.
         * The most common reason is revoking registration in quasar backend or invalidation of token made by user
         */
        virtual void onInvalidAuthentication(const std::string& uid) = 0;

        virtual ~AuthObserver() = default;
    };

} // namespace YandexIO
