#pragma once

//
// © YANDEX LLC, 2019
//

#pragma once

#include <string>

namespace YandexIO {

    class BackendConfigObserver {
    public:
        /**
         * Callback on received config from backend
         * @param configName -- json field in device config. We must to subscribe to this configName in YandexIOSDK class before we receive it
         * @param jsonConfigValue -- json value in device config
         * @note If configName disappeared from system_config Json::nullValue will be received
         */
        virtual void onSystemConfig(const std::string& configName, const std::string& jsonConfigValue);

        /**
         * Device-version of callback above
         */
        virtual void onDeviceConfig(const std::string& configName, const std::string& jsonConfigValue);

        /**
         * Account-version of callback above
         */
        virtual void onAccountConfig(const std::string& configName, const std::string& jsonConfigValue);

        enum class BackendConfigHandleStatus {
            OK,
            NETWORK_ERROR,
        };
        /**
         * @ Status of internal service which poll backend config. Is called periodically
         */
        virtual void onBackendConfigHandleStatus(BackendConfigHandleStatus status);

        virtual ~BackendConfigObserver();
    };

} // namespace YandexIO
