#pragma once

namespace YandexIO {
    struct ClockDisplayState {
    public:
        bool isClockOn;
        bool clockEnabled;
        bool showClockDuringDnd;
        double brightness;

        ClockDisplayState()
            : isClockOn(true)
            , clockEnabled(true)
            , showClockDuringDnd(true)
            , brightness(1.0)
        {
        }

        ClockDisplayState(bool isClockOn_, bool clockEnabled_, bool showClockDuringDnd_, double brightness_)
            : isClockOn(isClockOn_)
            , clockEnabled(clockEnabled_)
            , showClockDuringDnd(showClockDuringDnd_)
            , brightness(brightness_)
        {
        }

        bool operator==(const ClockDisplayState& other) const {
            return isClockOn == other.isClockOn &&
                   clockEnabled == other.clockEnabled &&
                   showClockDuringDnd == other.showClockDuringDnd &&
                   brightness == other.brightness;
        }
    };
} // namespace YandexIO
