#include "glagol_device_list_converter.h"

#include <yandex_io/libs/json_utils/json_utils.h>

namespace YandexIO {

    quasar::proto::AccountDevicesList convertDevicesListToProto(const glagol::IBackendApi::DevicesMap& devices) {
        quasar::proto::AccountDevicesList devicesList;
        for (auto& [deviceId, device] : devices) {
            auto dstDevice = devicesList.add_account_devices();
            dstDevice->set_id(TString(deviceId.id));
            dstDevice->set_platform(TString(deviceId.platform));
            dstDevice->set_name(TString(device.name));
            dstDevice->set_guest_mode(device.guestMode);
            dstDevice->set_server_certificate(TString(device.glagol.security.serverCertificate));
            dstDevice->set_server_private_key(TString(device.glagol.security.serverPrivateKey));
            if (device.group.isObject()) {
                dstDevice->set_group(TString(quasar::jsonToString(device.group)));
            }
            dstDevice->set_network_info(TString(quasar::jsonToString(device.networkInfo.serialize())));
        }
        return devicesList;
    }

    glagol::IBackendApi::DevicesMap convertDeviceListFromProto(const quasar::proto::AccountDevicesList& src) {
        glagol::IBackendApi::DevicesMap result;
        for (auto& device : src.account_devices()) {
            glagol::DeviceId id{device.id(), device.platform()};
            auto& dst = result[id];
            dst.name = device.name();
            dst.guestMode = device.guest_mode();
            dst.glagol.security.serverCertificate = device.server_certificate();
            dst.glagol.security.serverPrivateKey = device.server_private_key();
            if (device.has_group()) {
                try {
                    dst.group = quasar::parseJson(device.group());
                    dst.tandemRole = glagol::IBackendApi::Device::roleFromGroupJson(dst.group, id.id, id.platform);
                } catch (...) {
                }
            }
            if (device.has_network_info()) {
                try {
                    dst.networkInfo = glagol::IBackendApi::NetworkInfo::fromJson(quasar::parseJson(device.network_info()));
                } catch (...) {
                }
            }
        }
        return result;
    }

} // namespace YandexIO
