#include "glagol_discovery_result_converter.h"

using namespace quasar;

namespace YandexIO {

    glagol::IDiscovery::Result convertDiscoveryResultFromProto(const proto::GlagolDiscoveryResult& src) {
        using Result = glagol::IDiscovery::Result;
        Result result;
        for (auto& srcItem : src.items()) {
            glagol::DeviceId deviceId{.id = srcItem.device_id(), .platform = srcItem.platform()};
            Result::Item item;
            item.name = srcItem.name();
            item.accountDeviceName = srcItem.account_device_name();
            item.host = srcItem.host();
            item.address = srcItem.address();
            item.port = srcItem.port();
            item.uri = srcItem.uri();
            item.isAccountDevice = srcItem.is_account_device();
            item.cluster = srcItem.cluster();
            item.protocol = (Result::Protocol)srcItem.protocol();
            item.stereopairRole = srcItem.stereopair_role();
            item.tandemRole = srcItem.tandem_role();
            item.connectionActive = srcItem.available();
            result.items.emplace(std::move(deviceId), std::move(item));
        }
        return result;
    }

    proto::GlagolDiscoveryResult convertDiscoveryResultToProto(const glagol::IDiscovery::Result& src) {
        proto::GlagolDiscoveryResult result;
        for (auto [deviceId, srcItem] : src.items) {
            auto item = result.add_items();
            item->set_name(TString(srcItem.name));
            item->set_device_id(TString(deviceId.id));
            item->set_platform(TString(deviceId.platform));
            item->set_host(TString(srcItem.host));
            item->set_address(TString(srcItem.address));
            item->set_port(srcItem.port);
            item->set_uri(TString(srcItem.uri));
            item->set_is_account_device(srcItem.isAccountDevice);
            item->set_cluster(srcItem.cluster);
            item->set_protocol((proto::GlagolDiscoveryItem_ProtocolType)srcItem.protocol);
            item->set_account_device_name(TString(srcItem.accountDeviceName));
            item->set_stereopair_role(srcItem.stereopairRole);
            item->set_tandem_role(srcItem.tandemRole);
            item->set_available(srcItem.connectionActive);
        }
        return result;
    }

} // namespace YandexIO
