#pragma once

#include <string>

namespace YandexIO {
    struct DeviceGroupState {
        enum class Role {
            STAND_ALONE,
            LEADER,
            FOLLOWER
        };

        enum class ConnectionState {
            NONE,
            CONNECTING,
            CONNECTED
        };

        struct Leader {
            ConnectionState connectionState;
            std::string platform;
            std::string deviceId;
        };

        struct Follower {
            ConnectionState connectionState;
            std::string platform;
            std::string deviceId;
        };

        int groupId;
        Role localRole;
        Leader leader;
        Follower follower;
    };
} // namespace YandexIO
