#pragma once

//
// © YANDEX LLC, 2018
//

#pragma once

namespace YandexIO {
    class DeviceModeObserver {
    public:
        enum class ConfigurationSuccessState {
            HAS_UPDATE,
            NO_UPDATE
        };

        virtual void onStartSetup(bool) = 0;
        virtual void onSoundDataTransferStart() = 0;
        virtual void onConnectingToNetwork() = 0;
        virtual void onSetupError() = 0;
        virtual void onConfigureSuccessUpdate(ConfigurationSuccessState configurationSuccessState) = 0;

        virtual void onFinishSetup() = 0;

        virtual ~DeviceModeObserver() = default;
    };

} // namespace YandexIO
