#pragma once

#include <string>
#include <vector>
#include <optional>

namespace YandexIO {
    struct EqualizerInfo {
        struct Band {
            double freq{0.};
            double width{0.};
            double gain{0.};

            enum class Type {
                PEAK,
                LOW_SHELF,
                HIGH_SHELF
            };
            std::optional<Type> type;
        };

        bool preventClipping = false;
        std::vector<Band> bands;
    };
} /* namespace YandexIO */
