#include "io_hub_endpoint.h"

#include <yandex_io/protos/quasar_proto.pb.h>

namespace YandexIO {
    IOHubEndpoint::IOHubEndpoint(std::shared_ptr<quasar::ipc::IServer> services, std::shared_ptr<quasar::ipc::IServer> clients)
        : services_(std::move(services))
        , clients_(std::move(clients))
    {
        Y_VERIFY(services_);
        Y_VERIFY(clients_);
        // The simplest hub ever: just redirect expected messages
        services_->setMessageHandler([this](const auto& message, auto& /* connection */) {
            if (message->has_io_event()) {
                clients_->sendToAll(message);
            }
        });
        services_->setClientConnectedHandler([this](auto& /*connection*/) {
            handleNewServicesClient();
        });

        clients_->setMessageHandler([this](const auto& message, auto& /* connection */) {
            if (message->has_io_control() || (message->has_io_hub_message() && message->io_hub_message().has_retrieve_state())) {
                services_->sendToAll(message);
            }
        });
        clients_->setClientConnectedHandler([this](auto& /*connection*/) {
            handleNewSdkClient();
        });
        services_->listenService();
        clients_->listenService();
    }

    IOHubEndpoint::~IOHubEndpoint() {
        services_->shutdown();
        clients_->shutdown();
    }

    /**
     * Send retrieve_state to sdk clients and DeviceContext when Hub receive new connection
     * As an answer they should saved state
     */
    void IOHubEndpoint::handleNewServicesClient() {
        quasar::proto::QuasarMessage msg;
        msg.mutable_io_hub_message()->mutable_retrieve_state();
        clients_->sendToAll(std::move(msg));
    }

    void IOHubEndpoint::handleNewSdkClient() {
        quasar::proto::QuasarMessage msg;
        msg.mutable_io_hub_message()->mutable_retrieve_state();
        services_->sendToAll(std::move(msg));
    }

} /* namespace YandexIO */
