#include "io_hub_service.h"

#include "io_hub_endpoint.h"

#include <yandex_io/libs/ipc/i_server.h>

namespace YandexIO {
    IOHubService::IOHubService(std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory)
        : ipcFactory_(std::move(ipcFactory))
    {
    }

    IOHubService::~IOHubService() = default;

    std::string IOHubService::getServiceName() const {
        return "io_hub";
    }

    void IOHubService::start() {
        hub_ = std::make_unique<YandexIO::IOHubEndpoint>(
            ipcFactory_->createIpcServer("iohub_services"),
            ipcFactory_->createIpcServer("iohub_clients"));
    }

} /* namespace YandexIO */
