#pragma once

#include "io_hub_endpoint.h"

#include <yandex_io/libs/base/quasar_service.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <memory>

namespace YandexIO {
    class IOHubService: public QuasarService {
    public:
        IOHubService(std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory);
        ~IOHubService();
        std::string getServiceName() const override;

        void start() override;

    private:
        std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
        std::unique_ptr<YandexIO::IOHubEndpoint> hub_;
    };

} /* namespace YandexIO */
