#include "i_capability.h"
#include <util/system/yassert.h>

namespace YandexIO {

    ICapability::~ICapability() = default;
    ICapability::IListener::~IListener() = default;

    const std::string& ICapability::getId() const {
        static const auto* reflection = [] {
            const auto reflection = NAlice::TCapabilityHolder::GetReflection();
            Y_VERIFY(reflection);
            return reflection;
        }();
        static const auto* oneOfDescriptor = [] {
            const auto* descriptor = NAlice::TCapabilityHolder::GetDescriptor();
            Y_VERIFY(descriptor);
            const auto* oneOfDescriptor = descriptor->FindOneofByName("Capability");
            Y_VERIFY(oneOfDescriptor);
            return oneOfDescriptor;
        }();

        const auto* fieldDescriptor = reflection->GetOneofFieldDescriptor(getState(), oneOfDescriptor);
        if (!fieldDescriptor) {
            throw std::runtime_error("Fail to get default capability ID");
        }
        return fieldDescriptor->name();
    }

    const google::protobuf::Message& ICapability::getCapabilityFromHolder(const NAlice::TCapabilityHolder& state) {
        static const auto reflection = NAlice::TCapabilityHolder::GetReflection();
        static const auto oneofDescriptor = NAlice::TCapabilityHolder::GetDescriptor()->FindOneofByName("Capability");
        Y_VERIFY(oneofDescriptor);

        const auto capabilityDescriptor = reflection->GetOneofFieldDescriptor(state, oneofDescriptor);
        if (!capabilityDescriptor) {
            throw std::invalid_argument("Capability is not set");
        }

        return reflection->GetMessage(state, capabilityDescriptor);
    }

} // namespace YandexIO
