#pragma once

#include "i_directive_handler.h"

#include <yandex_io/protos/quasar_proto.pb.h>

#include <memory>
#include <string>

namespace YandexIO {

    class ICapability {
    public:
        class IListener {
        public:
            virtual ~IListener();

            virtual void onCapabilityStateChanged(const std::shared_ptr<ICapability>& capability, const NAlice::TCapabilityHolder& state) = 0;
            virtual void onCapabilityEvents(const std::shared_ptr<ICapability>& capability, const std::vector<NAlice::TCapabilityEvent>& events) = 0;
        };

    public:
        virtual ~ICapability();

        //
        // @brief Capability must define unique id inside endpoint scope
        //
        virtual const std::string& getId() const;
        virtual NAlice::TCapabilityHolder getState() const = 0;
        virtual IDirectiveHandlerPtr getDirectiveHandler() = 0;

        virtual void addListener(std::weak_ptr<IListener> wlistener) = 0;
        virtual void removeListener(std::weak_ptr<IListener> wlistener) = 0;

        static const google::protobuf::Message& getCapabilityFromHolder(const NAlice::TCapabilityHolder& state);
    };

} // namespace YandexIO
