#pragma once

#include "directive.h"

#include <memory>
#include <set>
#include <string>

namespace YandexIO {

    class IDirectiveHandler {
    public:
        virtual ~IDirectiveHandler();

        virtual const std::string& getEndpointId() const;
        virtual const std::string& getHandlerName() const = 0;
        virtual const std::set<std::string>& getSupportedDirectiveNames() const = 0;
        virtual void handleDirective(const std::shared_ptr<Directive>& directive) = 0;
        virtual void cancelDirective(const std::shared_ptr<Directive>& directive);
        virtual void prefetchDirective(const std::shared_ptr<Directive>& directive);

        /**
         * @brief This function called when directiveSequencer restores
         *        it's state on start and needs to sink directive instance with handler
         */
        virtual void restoreDirective(const std::shared_ptr<YandexIO::Directive>& directive);
    };

    using IDirectiveHandlerPtr = std::shared_ptr<IDirectiveHandler>;

} // namespace YandexIO
