#include "i_endpoint.h"

namespace YandexIO {

    IEndpoint::~IEndpoint() = default;
    IEndpoint::IListener::~IListener() = default;

    std::shared_ptr<ICapability> IEndpoint::findCapabilityById(const std::string& capabilityId) const {
        for (const auto& capability : getCapabilities()) {
            if (capability->getId() == capabilityId) {
                return capability;
            }
        }

        return nullptr;
    }

    NAlice::TEndpoint::EEndpointType IEndpoint::getType() const {
        return getState().GetMeta().GetType();
    }

} // namespace YandexIO
