#pragma once

#include "i_capability.h"
#include "i_directive_handler.h"

#include <yandex_io/protos/quasar_proto.pb.h>

#include <list>
#include <memory>
#include <string>

namespace YandexIO {

    class IEndpoint {
    public:
        class IListener {
        public:
            virtual ~IListener();

            virtual void onCapabilityAdded(const std::shared_ptr<IEndpoint>& enpdoint, const std::shared_ptr<ICapability>& capability) = 0;
            virtual void onCapabilityRemoved(const std::shared_ptr<IEndpoint>& enpdoint, const std::shared_ptr<ICapability>& capability) = 0;

            virtual void onEndpointStateChanged(const std::shared_ptr<IEndpoint>& endpoint) = 0;
        };

    public:
        virtual ~IEndpoint();

        virtual const std::string& getId() const = 0;
        virtual NAlice::TEndpoint getState() const = 0;
        virtual NAlice::TEndpoint::TStatus getStatus() const = 0;
        virtual void setStatus(const NAlice::TEndpoint::TStatus& status) = 0;

        virtual void addCapability(const std::shared_ptr<ICapability>& capability) = 0;
        virtual void removeCapability(const std::shared_ptr<ICapability>& capability) = 0;
        virtual std::list<std::shared_ptr<ICapability>> getCapabilities() const = 0;

        virtual void addListener(std::weak_ptr<IListener> wlistener) = 0;
        virtual void removeListener(std::weak_ptr<IListener> wlistener) = 0;

        std::shared_ptr<ICapability> findCapabilityById(const std::string& capabilityId) const;

        template <class Capability>
        std::shared_ptr<Capability> findCapability() const {
            for (const auto& capability : getCapabilities()) {
                if (auto concreteCapability = std::dynamic_pointer_cast<Capability>(capability)) {
                    return concreteCapability;
                }
            }

            return nullptr;
        }

        virtual std::shared_ptr<IDirectiveHandler> getDirectiveHandler() const = 0;

        NAlice::TEndpoint::EEndpointType getType() const;
    };

} // namespace YandexIO
