#include "i_endpoint_storage.h"

namespace YandexIO {

    IEndpointStorage::~IEndpointStorage() = default;
    IEndpointStorage::IListener::~IListener() = default;

    void IEndpointStorage::IListener::onCapabilityConfigChanged(const quasar::proto::CapabilityConfig& config) {
        Y_UNUSED(config);
    }

    std::shared_ptr<IEndpoint> IEndpointStorage::findEndpointById(const std::string& id) const {
        for (const auto& endpoint : getEndpoints()) {
            if (endpoint->getId() == id) {
                return endpoint;
            }
        }

        return nullptr;
    }

} // namespace YandexIO
