#pragma once

#include "i_endpoint.h"

#include <yandex_io/protos/model_objects.pb.h>

#include <list>
#include <memory>

namespace YandexIO {

    class IEndpointStorage {
    public:
        class IListener {
        public:
            virtual ~IListener();

            virtual void onEndpointAdded(const std::shared_ptr<IEndpoint>& endpoint) = 0;
            virtual void onEndpointRemoved(const std::shared_ptr<IEndpoint>& endpoint) = 0;

            // @Deprecated
            // Consider this callback as part of more high level layer
            // like DeviceController not pluged into remoting system yet
            virtual void onCapabilityConfigChanged(const quasar::proto::CapabilityConfig& config);
        };

    public:
        virtual ~IEndpointStorage();

        virtual std::shared_ptr<IEndpoint> createEndpoint(std::string id, NAlice::TEndpoint::EEndpointType type, NAlice::TEndpoint::TDeviceInfo deviceInfo, std::shared_ptr<IDirectiveHandler> directiveHandler = nullptr) = 0;
        virtual std::shared_ptr<IEndpoint> getLocalEndpoint() const = 0;

        virtual void addEndpoint(const std::shared_ptr<IEndpoint>& endpoint) = 0;
        virtual void removeEndpoint(const std::shared_ptr<IEndpoint>& endpoint) = 0;
        virtual std::list<std::shared_ptr<IEndpoint>> getEndpoints() const = 0;

        virtual void addListener(std::weak_ptr<IListener> wlistener) = 0;
        virtual void removeListener(std::weak_ptr<IListener> wlistener) = 0;

        std::shared_ptr<IEndpoint> findEndpointById(const std::string& id) const;
    };

} // namespace YandexIO
