#pragma once

#include <yandex_io/sdk/interfaces/directive.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockDirective: public YandexIO::Directive {
    public:
        MockDirective() {
            ON_CALL(*this, getData())
                .WillByDefault(testing::ReturnRef(defaultData_));
        }

        MOCK_METHOD(std::string, format, (), (const, override));
        MOCK_METHOD(const Data&, getData, (), (const, override));

        MOCK_METHOD(bool, getPrefetchInProgress, (), (const, override));
        MOCK_METHOD(void, setPrefetchInProgress, (bool), (override));

        MOCK_METHOD(bool, getFirstInChain, (), (const, override));
        MOCK_METHOD(void, setFirstInChain, (), (override));

        MOCK_METHOD(void, setPrefetchResult, (std::list<std::shared_ptr<Directive>>), (override));

    private:
        Data defaultData_;
    };

} // namespace YandexIO
