#pragma once

#include <yandex_io/sdk/interfaces/i_capability.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

#include <memory>

namespace YandexIO {

    class MockICapability: public ICapability, public std::enable_shared_from_this<MockICapability> {
    public:
        // installs default gmock handlers
        MockICapability(std::string id, std::shared_ptr<IDirectiveHandler> directiveHandler);

        MOCK_METHOD(const std::string&, getId, (), (const, override));
        MOCK_METHOD(NAlice::TCapabilityHolder, getState, (), (const, override));
        MOCK_METHOD(IDirectiveHandlerPtr, getDirectiveHandler, (), (override));

        MOCK_METHOD(void, addListener, (std::weak_ptr<IListener>), (override));
        MOCK_METHOD(void, removeListener, (std::weak_ptr<IListener>), (override));

        void notifyStateChanged(const NAlice::TCapabilityHolder& state);
        void notifyEvents(const std::vector<NAlice::TCapabilityEvent>& events);

    private:
        void addListenerDefault(std::weak_ptr<IListener> wlistener);
        void removeListenerDefault(std::weak_ptr<IListener> wlistener);

        const std::string id_;
        const std::shared_ptr<IDirectiveHandler> directiveHandler_;
        std::list<std::weak_ptr<ICapability::IListener>> listeners_;
    };

    class MockICapabilityListener: public ICapability::IListener {
    public:
        MOCK_METHOD(void, onCapabilityStateChanged, (const std::shared_ptr<ICapability>&, const NAlice::TCapabilityHolder&), (override));
        MOCK_METHOD(void, onCapabilityEvents, (const std::shared_ptr<ICapability>&, const std::vector<NAlice::TCapabilityEvent>&), (override));
    };

} // namespace YandexIO
