#pragma once

#include <yandex_io/sdk/interfaces/i_directive_handler.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIDirectiveHandler: public IDirectiveHandler {
    public:
        MOCK_METHOD(const std::string&, getHandlerName, (), (const, override));
        MOCK_METHOD(const std::set<std::string>&, getSupportedDirectiveNames, (), (const, override));
        MOCK_METHOD(const std::string&, getEndpointId, (), (const, override));
        MOCK_METHOD(void, handleDirective, (const std::shared_ptr<Directive>& directive), (override));
        MOCK_METHOD(void, cancelDirective, (const std::shared_ptr<Directive>& directive), (override));
        MOCK_METHOD(void, prefetchDirective, (const std::shared_ptr<Directive>& directive), (override));
    };

} // namespace YandexIO
