#pragma once

#include <yandex_io/sdk/interfaces/i_endpoint.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIEndpointListener: public IEndpoint::IListener {
    public:
        MOCK_METHOD(void, onCapabilityAdded, (const std::shared_ptr<IEndpoint>&, const std::shared_ptr<ICapability>&), (override));
        MOCK_METHOD(void, onCapabilityRemoved, (const std::shared_ptr<IEndpoint>&, const std::shared_ptr<ICapability>&), (override));

        MOCK_METHOD(void, onEndpointStateChanged, (const std::shared_ptr<IEndpoint>&), (override));
    };

    class MockIEndpoint: public IEndpoint {
    public:
        MOCK_METHOD(const std::string&, getId, (), (const, override));
        MOCK_METHOD(NAlice::TEndpoint, getState, (), (const, override));
        MOCK_METHOD(NAlice::TEndpoint::TStatus, getStatus, (), (const, override));
        MOCK_METHOD(void, setStatus, (const NAlice::TEndpoint::TStatus&), (override));

        MOCK_METHOD(void, addCapability, (const std::shared_ptr<ICapability>&), (override));
        MOCK_METHOD(void, removeCapability, (const std::shared_ptr<ICapability>&), (override));
        MOCK_METHOD(std::list<std::shared_ptr<ICapability>>, getCapabilities, (), (const, override));

        MOCK_METHOD(void, addListener, (std::weak_ptr<IListener>), (override));
        MOCK_METHOD(void, removeListener, (std::weak_ptr<IListener>), (override));
        MOCK_METHOD(std::shared_ptr<IDirectiveHandler>, getDirectiveHandler, (), (const, override));
    };

} // namespace YandexIO
