#pragma once

#include <yandex_io/sdk/interfaces/i_endpoint_storage.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIEndpointStorageListener: public IEndpointStorage::IListener {
    public:
        MOCK_METHOD(void, onEndpointAdded, (const std::shared_ptr<IEndpoint>&), (override));
        MOCK_METHOD(void, onEndpointRemoved, (const std::shared_ptr<IEndpoint>&), (override));
        MOCK_METHOD(void, onCapabilityConfigChanged, (const quasar::proto::CapabilityConfig&), (override));
    };

} // namespace YandexIO
