#pragma once

//
// © YANDEX LLC, 2018
//

#pragma once

namespace YandexIO {
    class MediaObserver {
    public:
        virtual ~MediaObserver() = default;

        /**
         * Type of content in Event.
         * NOTE: Currently VIDEO is supported for onMediaError only
         */
        enum class ContentType {
            MUSIC,
            VIDEO
        };
        virtual void onMediaError(ContentType contentType) = 0;

        virtual void onMediaRequest(ContentType contentType) = 0;
        virtual void onMediaStarted(ContentType contentType) = 0;
        virtual void onMediaPaused(ContentType contentType) = 0;
        virtual void onMediaResumed(ContentType contentType) = 0;

        virtual void onMediaSwitchedForward(ContentType contentType) = 0;
        virtual void onMediaSwitchedBackward(ContentType contentType) = 0;
        virtual void onMediaLiked(ContentType contentType) = 0;
        virtual void onMediaDisliked(ContentType contentType) = 0;
    };

} /* namespace YandexIO */
