#pragma once

#include <string>

namespace YandexIO {
    /**
     * @brief Observer for Music state updates
     */
    class MusicStateObserver {
    public:
        enum class TrackType {
            UNKNOWN,
            MUSIC,
            FAIRY_TALE,
            PODCAST,
            AUDIOBOOK
        };

        struct MusicState {
            bool isPaused;
            std::string title;
            std::string artists;
            std::string coverUri;
            double durationMs;
            double progress;
            TrackType nextTrackType;
        };

        virtual void onMusicStateChanged(const MusicState& musicState) = 0;

        virtual ~MusicStateObserver() = default;
    };

} // namespace YandexIO
