#pragma once

namespace YandexIO {
    class NotificationObserver {
    public:
        /**
         * Indicates that "notificationd" service is going to play notification sound.
         * All required settings should be set (e.g. proper volume).
         * Use YandexIOSDK::notifyPreparedForNotification() when device is ready.
         */
        virtual void onNotificationPending() = 0;

        /**
         * Notification sound has started playing
         */
        virtual void onNotificationStarted() = 0;

        /**
         * Notification sound has ended
         */
        virtual void onNotificationEnd() = 0;

        virtual ~NotificationObserver() = default;
    };

} // namespace YandexIO
