#pragma once

#include "directive_handler_proxy.h"
#include "connection_registry.h"

#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/sdk/private/remoting/i_remote_object.h>

#include <memory>

namespace YandexIO {

    class CapabilityProxy
        : public ICapability,
          public IRemoteObject,
          public std::enable_shared_from_this<CapabilityProxy> {
    public:
        CapabilityProxy(std::string id,
                        NAlice::TCapabilityHolder state,
                        std::shared_ptr<DirectiveHandlerProxy> directiveHandler,
                        std::weak_ptr<IRemotingRegistry> remotingRegistry,
                        std::shared_ptr<IConnectionRegistry> connectionRegistry);
        ~CapabilityProxy();

        void init(const std::string& endpointId);
        const std::string& getId() const override;
        NAlice::TCapabilityHolder getState() const override;
        IDirectiveHandlerPtr getDirectiveHandler() override;
        void addListener(std::weak_ptr<IListener> wlistener) override;
        void removeListener(std::weak_ptr<IListener> wlistener) override;

    private:
        void setState(NAlice::TCapabilityHolder state);
        void fireEvents(const std::vector<NAlice::TCapabilityEvent>& events);

        void handleRemotingMessage(
            const quasar::proto::Remoting& message,
            std::shared_ptr<IRemotingConnection> connection) override;

    private:
        const std::string id_;
        const std::shared_ptr<IConnectionRegistry> connections_;
        std::string remoteObjectId_;
        NAlice::TCapabilityHolder state_;
        const std::shared_ptr<DirectiveHandlerProxy> directiveHandler_;

        std::list<std::weak_ptr<ICapability::IListener>> listeners_;
    };

    class ProxyCapabilityListener: public ICapability::IListener {
    public:
        ProxyCapabilityListener(std::string endpointId_,
                                std::shared_ptr<IConnectionRegistry> connections);

        void onCapabilityStateChanged(const std::shared_ptr<ICapability>& capability,
                                      const NAlice::TCapabilityHolder& state) override;
        void onCapabilityEvents(const std::shared_ptr<ICapability>& capability,
                                const std::vector<NAlice::TCapabilityEvent>& events) override;

    private:
        const std::string endpointId_;
        const std::shared_ptr<IConnectionRegistry> connections_;
    };

} // namespace YandexIO
