#pragma once

#include <yandex_io/sdk/private/remoting/i_remoting_connection.h>
#include <yandex_io/protos/remoting.pb.h>

#include <map>
#include <memory>
#include <set>
#include <string>
#include <optional>

namespace YandexIO {

    class IConnectionRegistry {
    public:
        virtual ~IConnectionRegistry();
        virtual void putConnection(const std::string& name, std::weak_ptr<IRemotingConnection> connection) = 0;
        virtual void broadcastMessage(const quasar::proto::Remoting& message, const std::set<std::string>& ignoredConnections) = 0;
        virtual void sendMessage(const quasar::proto::Remoting& message, const std::string& storageName) = 0;

        virtual std::optional<std::string> getStorageName(const std::weak_ptr<IRemotingConnection>& connection) const = 0;
        virtual std::shared_ptr<IRemotingConnection> getConnection(const std::string& storageName) const = 0;
        virtual size_t getSize() const = 0;
    };

    class ConnectionRegistry: public IConnectionRegistry {
    public:
        void putConnection(const std::string& name, std::weak_ptr<IRemotingConnection> connection) override;
        void broadcastMessage(const quasar::proto::Remoting& message, const std::set<std::string>& ignoredConnections) override;
        void sendMessage(const quasar::proto::Remoting& message, const std::string& storageName) override;
        size_t getSize() const override;
        std::optional<std::string> getStorageName(const std::weak_ptr<IRemotingConnection>& connection) const override;
        std::shared_ptr<IRemotingConnection> getConnection(const std::string& storageName) const override;

    private:
        std::map<std::string, std::weak_ptr<IRemotingConnection>> connections_;
    };

} // namespace YandexIO
