#pragma once

#include <yandex_io/sdk/interfaces/i_endpoint.h>
#include <yandex_io/sdk/interfaces/i_capability.h>
#include <yandex_io/sdk/interfaces/i_directive_handler.h>

#include <yandex_io/protos/remoting.pb.h>

#include <memory>
#include <string>
#include <list>

namespace YandexIO {

    NAlice::TEndpoint convertEndpointStateToProtobuf(const std::shared_ptr<IEndpoint>& endpoint);

    quasar::proto::Capability convertCapabilityToProtobuf(
        const std::shared_ptr<IEndpoint>& endpoint,
        const std::shared_ptr<ICapability>& capability);

    quasar::proto::DirectiveHandler convertDirectiveHandlerToProtobuf(
        const std::string& endpointId,
        const std::shared_ptr<IDirectiveHandler>& directiveHandler);

    void appendCapabilities(NAlice::TEndpoint& state, std::list<std::shared_ptr<ICapability>> capabilities);

} // namespace YandexIO
