#include "remote_object_id_factory.h"

namespace YandexIO {

    std::string RemoteObjectIdFactory::createId(const std::shared_ptr<IEndpointStorage>& /*storage*/)
    {
        static const std::string s_prefix = "EndpointStorage_";
        return s_prefix;
    }

    std::string RemoteObjectIdFactory::createId(const std::shared_ptr<IEndpoint>& endpoint)
    {
        return createEndpointId(endpoint->getId());
    }

    std::string RemoteObjectIdFactory::createEndpointId(const std::string& endpointId) {
        static const std::string s_prefix = "Endpoint_";
        return s_prefix + endpointId;
    }

    std::string RemoteObjectIdFactory::createId(
        const std::string& endpointId, const std::shared_ptr<ICapability>& capability)
    {
        static const std::string s_prefix = "Capability_";

        return s_prefix + endpointId + "_" + capability->getId();
    }

} // namespace YandexIO
